<?php
namespace VM\ApiBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class SSOAuthorization
{
    /**
     * @var EntityManager
     */
    protected $EntityManager;

    /**
     * @var ContainerInterface
     */
    protected $Container;

    protected $curlRequest;

    protected $ssoUrlLogin;
    protected $ssoAppKey;


    public function __construct(EntityManager $EntityManager, ContainerInterface $Container, $SsoUrlLogin, $SsoAppKey)
    {
        $this->EntityManager = $EntityManager;
        $this->Container = $Container;
        $this->ssoUrlLogin = $SsoUrlLogin;
        $this->ssoAppKey = $SsoAppKey;
    }


    public function authenticate($login, $password)
    {
        $this->initConnection();
        $this->setOptions($login, $password);
        $loginResponse = $this->getResponse();

        $this->initConnection();
        $rolesResponse = $this->getUserRoles($loginResponse);

        if(empty($rolesResponse['roles']))
        {
            // tu dodać rolę w SSO
            $this->setUserRoles($loginResponse, array('ROLE_USER'));
            $rolesResponse['roles'] = array('ROLE_USER');
        }
        $loginResponse['roles'] = $rolesResponse['roles'];

        return $loginResponse;
    }



    protected function initConnection()
    {
        $this->curlRequest = curl_init($this->ssoUrlLogin);
    }


    protected function setOptions($login, $password)
    {
        $params = array(
            'params' => array(
                'email' => $login,
                'password' => md5($password),
            ),
            'appKey' => $this->ssoAppKey,
            'method' => 'user_login',
        );


        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($params)
        );

        curl_setopt_array($this->curlRequest, $options);
    }

    protected function getResponse()
    {
        $responseString = curl_exec($this->curlRequest);
        $request = $this->validateResponse($responseString);
        return $request;
    }


    /**
     * @param $responseString
     * @return mixed
     * @throws \Exception
     */
    protected function validateResponse($responseString)
    {
        $this->primaryValidation($responseString);

        $response = json_decode($responseString, true);

        if(!isset($response['user_id']) || empty($response['user_id']))
        {
            throw new \Exception('Not or empty user_id', 1001);
        }

        if(!isset($response['token']) || empty($response['token']))
        {
            throw new \Exception('Not or empty token', 1002);
        }

        return $response;
    }




    protected function getUserRoles($userLoginParams)
    {
        $userLoginParams['application'] = 'GAME';
        $params = array(
            'params' => $userLoginParams,
            'appKey' => $this->ssoAppKey,
            'method' => 'user_get_roles',
        );


        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($params)
        );

        curl_setopt_array($this->curlRequest, $options);

        $responseString = curl_exec($this->curlRequest);
        $this->primaryValidation($responseString);

        return json_decode($responseString, true);
    }


    protected function setUserRoles($userLoginParams, $roles = array())
    {
        $userLoginParams['application'] = 'GAME';
        $userLoginParams['roles'] = $roles;
        $params = array(
            'params' => $userLoginParams,
            'appKey' => $this->ssoAppKey,
            'method' => 'user_set_roles',
        );


        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($params)
        );

        curl_setopt_array($this->curlRequest, $options);

        $responseString = curl_exec($this->curlRequest);
        $this->primaryValidation($responseString);

        return json_decode($responseString, true);
    }


    protected function primaryValidation($responseString)
    {
        $info = curl_getinfo($this->curlRequest);
        if($info['http_code'] != 200)
        {
            throw new \Exception('response is empty', 404);
        }

        $error = curl_error($this->curlRequest);
        if(!empty($error))
        {
            throw new \Exception($error, 1010);
        }

        if(empty($responseString))
        {
            throw new \Exception('response is empty', 1000);
        }

        $response = json_decode($responseString, true);
        if(isset($response['error']))
        {
            throw new \Exception('Error Authorization SSO: '.$response['error']['message'], $response['error']['code']);
        }
    }
}